'CAR.BAS by Brian Giedt

DEFINT A-Z
SCREEN 1, 0

PI! = 4! * ATN(1!)
DIM A(200), B(200)
DIM RoadLine(3), R(500), S!

CIRCLE (4, 4), 2, 3             'draw wheel
CIRCLE (4, 4), 1, 3             'draw spokes inside wheel
GET (1, 1)-(6, 6), B            'capture wheel and put into B array
PUT (1, 1), B, XOR              'erases it from the screen

LINE (21, 30)-(28, 30), 3: LINE (34, 30)-(38, 30), 3      'draw car outline
LINE -(36, 25), 3: LINE -(33, 25), 3: LINE -(33, 23), 3
LINE -(24, 23), 3: LINE -(20, 25), 3: LINE -(11, 27), 3
LINE -(10, 30), 3: LINE -(15, 30), 3
CIRCLE (18, 31), 4, 3, 0, PI!   'wheel hubs
CIRCLE (31, 31), 4, 3, 0, PI!

PAINT (25, 25), 2, 3            'paint the car body red
LINE (25, 25)-(29, 26), 1, BF   'paint the window cyan

PUT (15, 28), B, XOR            'place wheels on the car
PUT (28, 28), B, XOR
GET (10, 22)-(38, 33), A        'capture first image of the car

PUT (15, 28), B, XOR            'remove wheels
PUT (28, 28), B, XOR
PUT (15, 29), B, XOR            'place the wheels one line below the position
PUT (28, 29), B, XOR            ' used before
GET (10, 23)-(38, 34), B        'capture second image of the car at one
                                '  pixel below where it was capture before
                                ' this provides the bouncing effect, while
                                ' the wheels always stay on the ground

PUT (10, 23), B, XOR            'erase extra image from the screen

LINE (12, 80)-(0, 116)          'capture a line at the angle of the road
GET (0, 80)-(12, 116), R

LINE (6, 94)-(319, 94)          'draw road
LINE (0, 130)-(319, 130)
'PAINT (319, 100), 1, 3         'optional to paint road white
RoadLine(1) = 30
RoadLine(2) = 130
RoadLine(3) = 230
FOR I = 1 TO 3                  'place lines across the road
   PUT (RoadLine(I), 94), R, XOR
NEXT

LINE (0, 80)-(12, 80), 2        'draw brick wall at the end of the road
LINE (12, 80)-(12, 94), 2
LINE (12, 94)-(0, 130), 2
PAINT (0, 113), 2, 2
LINE (12, 80)-(0, 116), 0

T = 280
S! = 0
I = 1

WHILE T                 'while car is still on the road

   PUT (T, 100), A, XOR 'place first image of the car
     CALL Roadlines(I)  'move one of the roadlines
     CALL Pause         'pause briefly
     CALL Roadlines(I)  'move another roadline
   PUT (T, 100), A, XOR 'remove first image of the car
                        'notice nothing is done while the image is off screen
   PUT (T, 100), B, XOR 'place second car image (car is raised above ground)
     CALL Roadlines(I)  'move one more of the roadlines
     CALL Pause         'pause again
     CALL Roadlines(I)  'move another roadline
   PUT (T, 100), B, XOR 'remove second image of car

   T = T - S!     'minimal calculations done while image is off the screen
   S! = S! + .1   'accelerate

WEND

PUT (T + S!, 100), B, XOR   'put image back on screen to show crash into wall

FOR T = 100 TO 50 STEP -1   'crash noise
    SOUND T, .2
    SOUND 32767, .1
NEXT
END

SUB Pause STATIC
   HoldTime! = TIMER
   WHILE TIMER < HoldTime! + .01
   WEND
END SUB

SUB Roadlines (I) STATIC
    SHARED RoadLine(), R(), S!
    PUT (RoadLine(I), 94), R, XOR
    RoadLine(I) = RoadLine(I) + S!
    IF RoadLine(I) > 305 THEN RoadLine(I) = 5
    PUT (RoadLine(I), 94), R, XOR
    I = (I MOD 3) + 1            'increments I from 1 to 3 inclusively
    SOUND 100 + (S! * 8), .2
END SUB
